using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class Unit : PI.GM.N610.ELearning.BL.DBD.Unit
    {
        #region Static factory
        private static Unit _factory = null;

        public static new Unit DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Unit();
                }
                return _factory;
            }
        }
        #endregion

        public enum ExtendedCommands
        {
            CountUnitExerciseDoneByUserWithMaxPoints = 101,
            CountUnitExerciseDoneByUser = 102
        }

        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)ExtendedCommands.CountUnitExerciseDoneByUserWithMaxPoints : return new ExtendedCommand_CountUnitExerciseDoneByUserWithMaxPoints();
                case (int)ExtendedCommands.CountUnitExerciseDoneByUser              : return new ExtendedCommand_CountUnitExerciseDoneByUser();
            }
            return base.DoGetCommand(CommandID);
        }

        #region Additional Commands Classes
        class ExtendedCommand_CountUnitExerciseDoneByUserWithMaxPoints : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountUnitExerciseDoneByUserWithMaxPoints() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                
                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UnitID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Unit_CountUnitExerciseDoneByUserWithMaxPoints";
            }
        }
        class ExtendedCommand_CountUnitExerciseDoneByUser : PI.FM.N000.Base.BL.DBD.BaseCommand<PI.GM.N610.ELearning.BL.BO.Course>
        {
            public ExtendedCommand_CountUnitExerciseDoneByUser() : base(PI.ZB.N1200.ELearning.BL.DBD.Course.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("DifficutltyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("NoDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("TeacherDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                
                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("UnitID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.BigInt, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Unit_CountUnitExerciseDoneByUser";
            }
        }
        #endregion
    }
}